<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set('max_execution_time', 300);

function searchServerForSimilarToken($directory) {
    $results = [];

    $pattern = '/\b\d+:[A-Za-z0-9_-]{35,}\b/';

    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($directory, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );

    foreach ($iterator as $file) {
        if ($file->isFile() && pathinfo($file->getPathname(), PATHINFO_EXTENSION) === 'php') {
            $content = file_get_contents($file->getPathname());
            if ($content === false) {
                continue;
            }
            if (preg_match_all($pattern, $content, $matches, PREG_OFFSET_CAPTURE)) {
                foreach ($matches[0] as $match) {
                    $token = $match[0];
                    $lineNumber = substr_count(substr($content, 0, $match[1]), "\n") + 1;
                    $results[] = [
                        'token' => $token,
                        'file' => $file->getPathname(),
                        'line' => $lineNumber
                    ];
                }
            }
        }
    }

    return $results;
}

// Get the directory of the script
$scriptDirectory = dirname(__FILE__);

// Define the directory to search (modify as needed)
$serverRoot = realpath($scriptDirectory . '/../'); // Move up one directory from the script directory

$foundTokens = searchServerForSimilarToken($serverRoot);

if (!empty($foundTokens)) {
    foreach ($foundTokens as $result) {
        echo "Token: {$result['token']}\n";
        echo "File: {$result['file']}\n";
        echo "Line: {$result['line']}\n";
        echo "------------------------------------\n";
    }
} else {
    echo "No tokens were found.\n";
}
?>